<?php
/*
Plugin Name: Related Products for WP e-Commerce
Plugin URI: http://www.visser.com.au/wp-ecommerce/plugins/related-products/
Description: Display related products in your WP e-Commerce store.
Version: 1.7.4
Author: Visser Labs
Author URI: http://www.visser.com.au/about/
License: Commercial
*/

include_once( 'includes/functions.php' );

switch( get_option( 'wpsc_version' ) ) {
	case '3.7':
		include_once( 'includes/release-3_7.php' );
		break;
	case '3.8':
		include_once( 'includes/release-3_8.php' );
		break;
}

if( is_admin() ) {

	add_action( 'admin_init','vl_wpscrp_admin_init' );
	add_action( 'after_plugin_row','vl_wpscrp_check_plugin_version' );

	function vl_wpscrp_admin_init() {

		global $vl_wpscrp_pluginname, $vl_wpscrp_menuname, $vl_wpscrp_plugindir, $vl_wpscrp_localversion;

		$vl_wpscrp_pluginname = __( 'Related Products for WP e-Commerce','vl_wpscrp' );
		$vl_wpscrp_menuname = __( 'Related Products','vl_wpscrp' );
		$vl_wpscrp_plugindir = basename( dirname( __FILE__ ) );
		$vl_wpscrp_localversion = '1.7.4';

	}

	function vl_wpscrp_check_plugin_version( $plugin ) {

		global $vl_wpscrp_pluginname, $vl_wpscrp_plugindir, $vl_wpscrp_localversion;

		if( strpos( $vl_wpscrp_plugindir.'/wp-e-commerce-related-products.php',$plugin ) !== false ) {
			$vl_wpscrp_vcheck = wp_remote_fopen( 'http://www.visser.com.au/?plugin_sku=RPWPE' );
			if( $vl_wpscrp_vcheck ) {
				$vl_wpscrp_status = explode( '@',$vl_wpscrp_vcheck );
				if( ( version_compare( strval( $vl_wpscrp_status[0] ),strval( $vl_wpscrp_localversion ),'>' ) == 1 ) ) {
					echo '<td colspan="5" class="plugin-update" style="line-height:1.2em; font-size:11px; padding:1px;"><div style="color:#000; font-weight:bold; margin:4px; padding:6px 5px; background-color:#fffbe4; border-color:#dfdfdf; border-width:1px; border-style:solid; -moz-border-radius:5px; -khtml-border-radius:5px; -webkit-border-radius:5px; border-radius:5px;">'.__( "There is a new version of ".$vl_wpscrp_pluginname." available.","vl_wpscrp" ).' <a href="'.$vl_wpscrp_status[1].'">'.__( "View version ","vl_wpscrp" ).$vl_wpscrp_status[0].__( " details","vl_wpscrp" ).'</a>.</div></td>';
				} else {
					return;
				}
			}
		}

	}

	register_activation_hook(__FILE__, 'vl_wpscrp_install');

	function vl_wpscrp_install() {

		vl_wpscrp_create_options();
		vl_wpscrp_update_meta();
	}

	function vl_wpscrp_create_options() {

		if( !get_option( 'vl_wpscrp_position' ) )
			add_option( 'vl_wpscrp_position','wpsc_product_addon_after_descr' );
		if( !get_option( 'vl_wpscrp_limit') )
			add_option( 'vl_wpscrp_limit','6' );
		if( !get_option( 'vl_wpscrp_layout' ) )
			add_option( 'vl_wpscrp_layout','table-vertical.php' );
		if( !get_option( 'vl_wpscrp_display_title' ) )
			add_option( 'vl_wpscrp_display_title','1' );
		if( !get_option( 'vl_wpscrp_title_text' ) )
			add_option( 'vl_wpscrp_title_text','Related Products' );
	}

	function vl_wpscrp_init_meta_box() {

		switch( get_option( 'wpsc_version' ) ) {

			case '3.7':
				$pagename = 'store_page_wpsc-edit-products';
				break;

			case '3.8':
				$pagename = 'toplevel_page_wpsc-edit-products';
				break;

		}
		add_meta_box( 'vl_wpscrp_meta_box','Related Products','vl_wpscrp_meta_box',$pagename,'normal','high' );

	}
	add_action( 'admin_menu','vl_wpscrp_init_meta_box' );

	function vl_wpscrp_add_to_product_form( $order ) {

		switch( get_option( 'wpsc_version' ) ) {

			case '3.7':
				$pagename = 'store_page_wpsc-edit-products';
				if(array_search('vl_wpscrp_meta_box', (array)$order) === false)
					$order[] = 'vl_wpscrp_meta_box';
				break;

			case '3.8':
				$pagename = 'toplevel_page_wpsc-edit-products';
				if(array_search('vl_wpscrp_meta_box', (array)$order['side']) === false)
					$order['side'][] = 'vl_wpscrp_meta_box';
				break;

		}
		return $order;

	}
	add_filter( 'wpsc_products_page_forms','vl_wpscrp_add_to_product_form' );

	function vl_wpscrp_meta_box( $product_data=array() ) {

		global $wpdb, $closed_postboxes;

		$disregard_product = get_product_meta( $product_data['id'],'vl_wpscrp_disregard',true );
		$related_products = get_product_meta( $product_data['id'],'vl_wpscrp_manual',true );
		$products_sql = "SELECT id, name FROM ".$wpdb->prefix."wpsc_product_list WHERE active = '1'";
		$products = $wpdb->get_results( $products_sql ); ?>
<div id="wpsc_product_related_products" class="postbox <?php echo ((array_search('vl_wpscrp_meta_box', (array)$product_data['closed_postboxes']) !== false) ? 'closed"' : '');	?>" <?php echo ((array_search('vl_wpscrp_meta_box', (array)$product_data['hidden_postboxes']) !== false) ? ' style="display: none;"' : ''); ?>>
	<h3 class="hndle"><?php _e( 'Related Products','vl_wpscrp' ); ?></h3>
	<div class="inside">
		<div>
			<p><span class="howto"><?php _e( 'Related Products','vl_wpscrp' ); ?></span></p>
			<table>
				<tr>
					<td scope="row" style="padding:0 0 0.5em 0;"><input type="checkbox" id="vl_wpscrp_product_0" name="productmeta_values[vl_wpscrp_manual][]" value="0"<?php if( $related_products == '0' ) { echo ' checked="checked"'; } ?> /></td>
					<td valign="middle"><label for="vl_wpscrp_product_0"><?php _e( 'Use automatic selection of Related Products','vl_wpscrp' ); ?></label></td>
				</tr>
<?php
		foreach( $products as $product ) {
			$selected = '';
			if( $related_products ) {
				if( count( $related_products ) > 1 ) {
					foreach( $related_products as $related_product ) {
						if( $product->id == $related_product )
							$selected = ' checked="checked"';
					}
				} else {
					if( $product->id == $related_products )
						$selected = ' checked="checked"';
				}
			}
			if( $product_data['id'] <> $product->id ) { ?>
				<tr id="product-<?php echo $product->id; ?>">
					<th scope="row"><input type="checkbox" id="vl_wpscrp_product_<?php echo $product->id; ?>" name="productmeta_values[vl_wpscrp_manual][]"<?php echo $selected; ?> value="<?php echo $product->id; ?>" /></th>
					<td valign="middle" style="overflow:hidden;" nowrap><label for="vl_wpscrp_product_<?php echo $product->id; ?>"><?php if( strlen( $product->name ) < 65 ) { echo $product->name; } else { echo substr( $product->name,0,65 ).'...'; } ?></label></td>
				</tr>
<?php
			}
		} ?>
				<tr>
					<td scope="row" style="padding:0.5em 0 0 0;"><input type="checkbox" id="vl_wpscrp_disregard" name="productmeta_values[vl_wpscrp_disregard]"<?php if( $disregard_product == 'on' ) { echo ' checked="checked"'; } ?> /></td>
					<td valign="middle" style="padding:0.5em 0 0 0;"><label for="vl_wpscrp_disregard"><?php _e( 'Disregard Related Products for this product','vl_wpscrp' ); ?></label></td>
				</tr>
			</table>
		</div>
	</div>
</div>
<?php

	}

	function vl_wpscrp_html_page() {

		global $wpdb, $vl_wpscrp_menuname;

		$action = $_GET['action'];
		if( !$action )
			$action = $_POST['action']; ?>
<div class="wrap">
	<div id="icon-tools" class="icon32"><br /></div>
	<h2><?php echo $vl_wpscrp_menuname; ?></h2>
<?php
		switch( $action ) {
			case 'update':
				$vl_wpscrp_position = $_POST['vl_wpscrp_position'];
				$vl_wpscrp_limit = $_POST['vl_wpscrp_limit'];
				$vl_wpscrp_layout = $_POST['vl_wpscrp_layout'];
				$vl_wpscrp_display_title = $_POST['vl_wpscrp_display_title'];
				$vl_wpscrp_title_text = $_POST['vl_wpscrp_title_text'];
				update_option( 'vl_wpscrp_position',$vl_wpscrp_position );
				update_option( 'vl_wpscrp_limit',$vl_wpscrp_limit );
				update_option( 'vl_wpscrp_layout',$vl_wpscrp_layout );
				update_option( 'vl_wpscrp_display_title',$vl_wpscrp_display_title );
				update_option( 'vl_wpscrp_title_text',$vl_wpscrp_title_text ); ?>
	<div class="updated settings-error">
		<p><strong><?php _e( 'Settings saved.','vl_wpscrp' ); ?></strong></p>
	</div>
<?php
				vl_wpscrp_options_form();
				break;
			default:
				vl_wpscrp_options_form();
				break;
		} ?>
</div>
<?php

	}

	function vl_wpscrp_options_form() { ?>
	<form method="post" action="<?php the_permalink(); ?>" id="your-profile">
		<h3><?php _e( 'General','vl_wpscrp' ); ?></h3>
		<table class="form-table">
			<tr>
				<th scope="row"><label for="vl_wpscrp_limit"><?php _e( 'Number of Products','vl_wspcrp' ); ?>:</label></th>
				<td>
					<input type="text" name="vl_wpscrp_limit" size="3" value="<?php echo get_option( 'vl_wpscrp_limit' ); ?>" /> <em><?php _e( 'The number of suggested Products to be displayed.','vl_wpscrp' ); ?></em>
				</td>
			</tr>
			<tr>
				<th scope="row"><label for="vl_wpscrp_position"><?php _e( 'Position','vl_wpscrp' ); ?>:</label></th>
				<td>
					<select name="vl_wpscrp_position">
<?php
		$positions = array();
		$positions[] = array( 'wpsc_top_of_products_page',__( 'Top','vl_wpscrp' ) );
		$positions[] = array( 'wpsc_product_before_description',__( 'Before Description','vl_wpscrp' ) );
		$positions[] = array( 'wpsc_product_addons',__( 'Addons','vl_wpscrp' ) );
		$positions[] = array( 'wpsc_product_addon_after_descr',__( 'After Description','vl_wpscrp' ) );
		$positions[] = array( 'manual',__( 'Manual','vl_wpscrp' ) );
		foreach( $positions as $position ) {
			if( $position[0] == get_option( 'vl_wpscrp_position' ) )
				echo '<option value="'.$position[0].'" selected="selected">'.$position[1].'</option>';
			else
				echo '<option value="'.$position[0].'">'.$position[1].'</option>';
		} ?>
					</select> <em><?php _e( 'The placement of Related Products within the Product details template.','vl_wpscrp' ); ?></em>
				</td>
			</tr>
		</table>
		<p><?php _e( 'For manual positioning use the following PHP template tag within the Single Product template','vl_wpscrp' ); ?>.</p>
		<p><code><?php echo htmlentities2( '<?php echo wpsc_the_related_products(); ?>' ); ?></code></p>
		<h3><?php _e( 'Presentation','vl_wpscrp' ); ?></h3>
		<table class="form-table">
			<tr>
				<th scope="row"><label for="vl_wpscrp_layout"><?php _e( 'Layout','vl_wpscrp' ); ?>:</label></th>
				<td>
					<select name="vl_wpscrp_layout">
<?php
		$layouts = array();
		$layouts[] = array( 'table-vertical.php',__( 'Table - Vertical','vl_wpscrp' ) );
		$layouts[] = array( 'table-horizontal.php',__( 'Table - Horizontal','vl_wpscrp' ) );
		$layouts[] = array( 'list-ordered.php',__( 'List - Ordered','vl_wpscrp' ) );
		$layouts[] = array( 'list-unordered.php',__( 'List - Unordered','vl_wpscrp' ) );
		foreach( $layouts as $layout ) {
			if( $layout[0] == get_option( 'vl_wpscrp_layout' ) )
				echo '<option value="'.$layout[0].'" selected="selected">'.$layout[1].'</option>';
			else
				echo '<option value="'.$layout[0].'">'.$layout[1].'</option>';
		} ?>
					</select> <em><?php _e( 'The orientation of Related Products within the Product details template.','vl_wpscrp' ); ?></em>
				</td>
			</tr>
			<tr>
				<th scope="row"><label><?php _e( 'Header Visibility','vl_wpscrp' ); ?>:</label></th>
				<td>
					<fieldset>
						<label><input type="radio" name="vl_wpscrp_display_title" value="1"<?php if( get_option( 'vl_wpscrp_display_title' ) == '1' ) { echo ' checked="checked"'; } ?> /> <?php _e( 'I would like to display the Related Products header','vl_wpscrp' ); ?></label><br />
						<label><input type="radio" name="vl_wpscrp_display_title" value="0"<?php if( get_option( 'vl_wpscrp_display_title' ) == '0' ) { echo ' checked="checked"'; } ?> /> <?php _e( 'I would like to hide the Related Products header','vl_wpscrp' ); ?></label>
					</fieldset>
					<em><?php _e( 'Show or hide the Related Products header.','vl_wpscrp' ); ?></em>
				</td>
			</tr>
			<tr>
				<th scope="row"><label><?php _e( 'Header Title','vl_wpscrp' ); ?>:</label></th>
				<td>
					<input type="text" name="vl_wpscrp_title_text" value="<?php echo get_option( 'vl_wpscrp_title_text' ); ?>" size="10" class="regular-text" /> <em><?php _e( 'The header text for Related Products.','vl_wpscrp' ); ?></em>
				</td>
			</tr>
		</table>
		<p class="submit">
			<input type="submit" value="<?php _e( 'Save Changes','vl_wpscrp' ); ?>" class="button-primary" />
		</p>
		<input type="hidden" name="action" value="update" />
	</form>
<?php
	}

	function vl_wpscrp_update_meta() {

		global $wpdb;

		/* Update references to custom Product meta 'manual' */
		$manual_products_sql = "SELECT product_id, meta_value FROM ".$wpdb->prefix."wpsc_productmeta WHERE meta_key = 'manual'";
		$manual_products = $wpdb->get_results( $manual_products_sql );
		foreach( $manual_products as $manual_product ) {
			add_product_meta( $manual_product->product_id,'vl_wpscrp_manual',$manual_product->meta_value );
			delete_product_meta( $manual_product->product_id,'manual' );
		}

		/* Update references to custom Product meta 'disregard' */
		$disregard_products_sql = "SELECT product_id, meta_value FROM ".$wpdb->prefix."wpsc_productmeta WHERE meta_key = 'disregard'";
		$disregard_products = $wpdb->get_results( $disregard_products_sql );
		foreach( $disregard_products as $disregard_product ) {
			add_product_meta( $disregard_product->product_id,'vl_wpscrp_disregard',$disregard_product->meta_value );
			delete_product_meta( $disregard_product->product_id,'disregard' );
		}

	}

} else {

	if( get_option( 'vl_wpscrp_position' ) )
		add_action( get_option( 'vl_wpscrp_position' ),'vl_wpscrp_init' );
	else
		add_action( 'wpsc_product_addon_after_descr','vl_wpscrp_init' );
	add_action( 'wp_print_styles','vl_wpscrp_load_styles' );

	function vl_wpscrp_init() {

		global $wpsc_query;

		if( $wpsc_query->is_single ) {
			if( get_option( 'vl_wpscrp_position' ) <> 'manual' )
				vl_wpscrp_html_product();
		}

	}

	function wpsc_the_related_products() {

		if( get_option( 'vl_wpscrp_position' ) == 'manual' )
			vl_wpscrp_html_product();

	}

	function vl_wpscrp_load_styles() {

		if( get_option( 'vl_wpscrp_theme' ) ) {
			if ( file_exists( TEMPLATEPATH . '/wpsc-single_product_related_' . get_option( 'vl_wpscrp_theme' ) ) )
				wp_enqueue_style( 'vl_wpscrp',TEMPLATEPATH . '/wpsc-single_product_related_' . get_option( 'vl_wpscrp_theme' ),false,'1.0.0','screen' );
		} else {
			wp_enqueue_style( 'vl_wpscrp',plugins_url( '/themes/default.css',__FILE__ ),false,'1.0.0','screen' );
		}

	}

	function vl_wpscrp_html_product() {

		global $wpdb, $wpsc_query;

		$disregard = get_product_meta( wpsc_the_product_id(),'vl_wpscrp_disregard' );
		if( !$disregard )
			$disregard = 'off';

		if( $disregard == 'off' ) {
			$limit = get_option( 'vl_wpscrp_limit' );
			$manual_products = get_product_meta( wpsc_the_product_id(),'vl_wpscrp_manual',true );
			$rotation = get_product_meta( wpsc_the_product_id(),'vl_wpscrp_rotation',true );
			if( $manual_products ) {
				$products = array();
				if( count( $manual_products ) > 1 ) {
					$i = 0;
					foreach( $manual_products as $manual_product ) {
						if( $i < $limit ) {
							if( wpsc_the_product_id() <> $manual_product ) {
								$manual_productdata_sql = "SELECT name, image FROM ".$wpdb->prefix."wpsc_product_list WHERE id = '" . $manual_product . "' LIMIT 1";
								$manual_productdata = $wpdb->get_row( $manual_productdata_sql );
								if( $manual_productdata ) {
									$products[] = array(
									'id' => $manual_product, 
									'name' => $manual_productdata->name, 
									'image' => $manual_productdata->image
									);
								}
								unset( $manual_productdata );
								$i++;
							}
						}
					}
				} else {
					$auto_productdata_sql = "SELECT name, image FROM ".$wpdb->prefix."wpsc_product_list WHERE id = '".$manual_products."' LIMIT 1";
					$auto_productdata = $wpdb->get_row( $auto_productdata_sql );
					if( $auto_productdata ) {
						$products[] = array(
						'id' => $manual_products, 
						'name' => $auto_productdata->name, 
						'image' => $auto_productdata->image
						);
					}
				}
				$products = array2obj( $products );
			} else {
				if( $rotation )
					$products_sql = "SELECT * FROM " . $wpdb->prefix . "wpsc_product_list WHERE " . $wpdb->prefix . "wpsc_product_list.active = '1' AND " . $wpdb->prefix . "wpsc_product_list.id IN (" . $rotation . ") LIMIT 0," . $limit;
				else
					$products_sql = "SELECT " . $wpdb->prefix . "wpsc_product_list.* FROM " . $wpdb->prefix . "wpsc_product_list LEFT JOIN " . $wpdb->prefix . "wpsc_item_category_assoc ON " . $wpdb->prefix . "wpsc_product_list.id = " . $wpdb->prefix . "wpsc_item_category_assoc.product_id WHERE " . $wpdb->prefix . "wpsc_product_list.active = '1' AND " . $wpdb->prefix . "wpsc_product_list.publish = '1' AND " . $wpdb->prefix . "wpsc_item_category_assoc.category_id = '" . $wpsc_query->query_vars['category_id'] . "' AND " . $wpdb->prefix . "wpsc_product_list.id <> " . wpsc_the_product_id() . " LIMIT 0," . $limit;
				$products = $wpdb->get_results( $wpdb->prepare( $products_sql ) );
			}

			if ( file_exists( TEMPLATEPATH . '/wpsc-single_product_related_' . get_option( 'vl_wpscrp_layout' ) ) )
				include( TEMPLATEPATH . '/wpsc-single_product_related_' . get_option( 'vl_wpscrp_layout' ) );
			else
				include( 'themes/'.get_option( 'vl_wpscrp_layout' ) );

		}

	}

} ?>