<?php
if( is_admin() ) {

	if( !function_exists( 'vl_wpsc_dashboard_setup' ) ) {

		function vl_wpsc_dashboard_setup() {

			wp_add_dashboard_widget('vl_wpsc_news_widget', __( 'Plugin News - by Visser Labs','vl_wpsc' ),'vl_wpsc_news_widget');

		}
		add_action('wp_dashboard_setup', 'vl_wpsc_dashboard_setup');

		function vl_wpsc_news_widget() {

			include_once( ABSPATH . WPINC . '/feed.php' );

			$rss = fetch_feed( 'http://www.visser.com.au/blog/category/e-commerce/feed/' );
			if (!is_wp_error( $rss ) ) : // Checks that the object is created correctly
				// Figure out how many total items there are, but limit it to 5.
				$maxitems = $rss->get_item_quantity(5);
				// Build an array of all the items, starting with element 0 (first element).
				$rss_items = $rss->get_items(0, $maxitems);
			endif;

			$output = '<div class="rss-widget"><ul>';
			foreach ( $rss_items as $item ) :
				$output .= '<li>';
				$output .= '<a href="' . $item->get_permalink() . '" title="' . 'Posted ' . $item->get_date('j F Y | g:i a') . '" class="rsswidget">' . $item->get_title() . '</a>';
				$output .= '<span class="rss-date">' . $item->get_date( 'j F, Y' ) . '</span>';
				$output .= '<div class="rssSummary">' . $item->get_description() . '</div>';
				$output .= '</li>';
			endforeach;
			$output .= '</ul></div>';
			echo $output;

		}

	}

} else {

	function vl_wpscrp_scmp( $a, $b ) {
		return rand(-1,1);
	}

	/**
	 * Convert a multi-dimensional array into a stdClass object.
	 * 
	 * Example:
	 * 	$values = array('hello'=>'world');
	 * 
	 * 	// Convert the array to an object
	 * 	array_to_object($values);
	 * 
	 * 	echo $values->hello;
	 *
	 * @param array $array The input array
	 * @return object
	 */
	if( !function_exists( 'array2obj' ) ) {
		function array2obj($array) {

			return is_array($array) ? (object) array_map(__FUNCTION__,$array) : $array;

		}
	}

	function vl_wpscrp_product_thumbnail( $product_id, $product_image ) {

		global $wpdb;

		$image_file_name = $wpdb->get_var("SELECT `image` FROM `" . WPSC_TABLE_PRODUCT_IMAGES . "` WHERE `id`= '" . $product_image . "' LIMIT 1");
		if ( $image_file_name !== null ) {
			$image_path = WPSC_THUMBNAIL_URL . $image_file_name;
			return $image_path;
		} else {
			return false;
		}

	}

}
?>